import pandas as pd  
from sklearn.preprocessing import StandardScaler   
import pickle
from decision_company import read_csv_file, df_copy, get_first_n_rows, create_standard_scaler, fit_transform_standard_scaler, col_assign_val
  
  
# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# It's true:  
# Normalize the data using Standard Scaling  
if normalization_needed: 
    scaler = create_standard_scaler()  
    credit_customers_normalized = df_copy(credit_customers)  
    col_assign_val(credit_customers_normalized, numerical_columns, fit_transform_standard_scaler(scaler, credit_customers[numerical_columns]))
  
    print("Data after Standard Scaling:\n", get_first_n_rows(credit_customers_normalized))  
    pickle.dump(get_first_n_rows(credit_customers_normalized), open("./ref_result/credit_customers_normalized_head.pkl", "wb"))  
else:
    print("Normalization is not needed.")  
    
